<?php
// Enable error reporting
error_reporting(E_ALL); // Report all types of errors
ini_set('display_errors', 1); // Display errors on the screen

// Include database connection
include 'conn.php';

// Initialize variables
$classes = [];
$selected_class = '';
$report_type = '';
$message = '';

// Fetch all classes
$classes_result = $conn->query("SELECT DISTINCT `class` FROM students");
if ($classes_result->num_rows > 0) {
    while ($row = $classes_result->fetch_assoc()) {
        $classes[] = $row['class'];
    }
}

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $selected_class = $_POST['class'];
    $report_type = $_POST['report_type'];

    if ($report_type == 'student') {
        // Generate report for each student
        $sql = "SELECT s.fullname, b.book_name, b.form 
                FROM books_already_given AS bag 
                JOIN students AS s ON bag.admission_number = s.admission_number 
                JOIN books AS b ON bag.book_no = b.book_no 
                WHERE s.class = '$selected_class'";
        
        if ($result = $conn->query($sql)) {
            if ($result->num_rows > 0) {
                // Directory to save individual reports
                $report_dir = 'reports/';
                if (!is_dir($report_dir)) {
                    mkdir($report_dir, 0777, true);
                }

                // Generate a report for each student
                while ($row = $result->fetch_assoc()) {
                    $fullname = $row['fullname'];
                    $book_name = $row['book_name'];
                    $form = $row['form'];

                    $html_content = "
                        <html>
                        <head>
                            <style>
                                body { font-family: Arial, sans-serif; }
                                .report { border: 1px solid #ddd; padding: 20px; margin: 20px; }
                                .header { font-size: 24px; font-weight: bold; text-align: center; margin-bottom: 20px; }
                                .content { margin-bottom: 20px; }
                            </style>
                        </head>
                        <body>
                            <div class='report'>
                                <div class='header'>Student Book Report</div>
                                <div class='content'>
                                    <p><strong>Student Name:</strong> {$fullname}</p>
                                    <p><strong>Book Name:</strong> {$book_name}</p>
                                    <p><strong>Form:</strong> {$form}</p>
                                </div>
                            </div>
                        </body>
                        </html>";

                    // File path
                    $file_path = $report_dir . str_replace(' ', '_', $fullname) . '.html';

                    // Save the HTML content to a file
                    file_put_contents($file_path, $html_content);
                }

                $message = "<div class='message success'>Reports generated successfully. <a href='reports/'>Download reports</a></div>";
            } else {
                $message = "<div class='message error'>No records found for Class: $selected_class</div>";
            }
        }
    } else {
        $message = "<div class='message error'>Please select a valid report type.</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generate Report</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background: #f0f4f8;
        }
        .container {
            width: 80%;
            max-width: 800px;
            margin: 40px auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #666;
        }
        .form-group select, .form-group input[type="radio"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            box-sizing: border-box;
        }
        .btn-submit {
            width: 100%;
            padding: 12px;
            background-color: #007bff;
            color: #ffffff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            transition: background-color 0.3s;
            text-align: center;
        }
        .btn-submit:hover {
            background-color: #0056b3;
        }
        .message {
            text-align: center;
            margin-top: 20px;
            padding: 10px;
            border-radius: 5px;
            font-size: 16px;
        }
        .message.success {
            color: #28a745;
            border: 1px solid #28a745;
            background-color: #d4edda;
        }
        .message.error {
            color: #dc3545;
            border: 1px solid #dc3545;
            background-color: #f8d7da;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Generate Report</h2>
        <form method="post" action="">
            <div class="form-group">
                <label for="class">Select Class</label>
                <select id="class" name="class" required>
                    <option value="">--Select Class--</option>
                    <?php foreach ($classes as $class): ?>
                        <option value="<?php echo htmlspecialchars($class); ?>"><?php echo htmlspecialchars($class); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label>Report Type</label>
                <input type="radio" id="class" name="report_type" value="class">
                <label for="class">Class Report</label>
                <input type="radio" id="student" name="report_type" value="student" required>
                <label for="student">Individual Student Report</label>
            </div>
            <button type="submit" class="btn-submit"><i class="fas fa-file-alt"></i> Generate Report</button>
        </form>
        <?php echo $message; ?>
    </div>
</body>
</html>
